#!/bin/sh
#
# =========================================================================
# Copyright (c) 2003, Josh Glover <jmglov@jmglov.net>
#
# LICENCE:
#
#   This file is distributed under the terms of the BSD License, version
#   2. See the COPYING file, which should have been distributed with this
#   file, for details. If you did not receive the COPYING file, see:
#
#   http://www.jmglov.net/opensource/licences/bsd.txt
#
# do-overlay-ebuild.sh
#
# DESCRIPTION:
#
#   Copies the specified ebuild[s] into the Portage overlay directory
#   in the specified category.
#
# USAGE:
#
#   do-overlay-ebuild.sh <category> <ebuild0> [<ebuild1> ... <ebuildN>]
#
#   Make sure to run as root! (e.g. 'sudo ./do-overlay-ebuild.sh ...')
#
# EXAMPLES:
#
#   do-overlay-ebuild.sh net-www bugport*.ebuild
#
# DEPENDENCIES:
#
#   None
#
# TODO:
#
#   - Nothing, this code is perfect
#
# MODIFICATIONS:
#
#   Josh Glover <jmglov@jmglov.net> (2003/12/03): Initial revision
# =========================================================================

# Create the overlay directory, unless it has already been done
if test -e ./do-overlay.sh; then
  ./do-overlay.sh || exit $?
else
  do-overlay.sh || exit $?
fi

# Spew a usage message if we don't have a category and at least one ebuild
if test -z $2; then
  echo 'Usage: do-overlay-ebuild.sh <category> <ebuild0> [<ebuild1> ... <ebuildN>]'
  exit 1
fi

# Grab the category and list of ebuilds
category=$1; shift
ebuilds="$@"

# Determine the overlay directory
overlay=`grep ^PORTDIR_OVERLAY /etc/make.conf | awk -F= '{print $2}'`

# Create the category directory
test -d ${overlay}/${category} || mkdir ${overlay}/${category}

# Create the ebuild directory[s] and copy the ebuilds into them
for i in ${ebuilds}; do

  p=`basename ${i}`
  pn=`echo ${p} | awk '{ sub( /-[0-9\.]+ebuild$/, "" ); print }'`
  test -d ${overlay}/${category}/${pn} || mkdir ${overlay}/${category}/${pn}
  cp ${i} ${overlay}/${category}/${pn}/

  # Create the digest while we are at it
  rm /usr/portage/distfiles/${pn}*
  ebuild ${overlay}/${category}/${pn}/${p} digest

done
