#!/bin/sh
#
# =========================================================================
# Copyright (c) 2003, Josh Glover <jmglov@jmglov.net>
#
# LICENCE:
#
#   This file is distributed under the terms of the BSD License, version
#   2. See the COPYING file, which should have been distributed with this
#   file, for details. If you did not receive the COPYING file, see:
#
#   http://www.jmglov.net/opensource/licences/bsd.txt
#
# do-overlay.sh
#
# DESCRIPTION:
#
#   Sets up /usr/local/portage as a Portage overlay directory. If you already
#   have a Portage overlay directory, nothing will be done.
#
# USAGE:
#
#   do-overlay.sh
#
#   Make sure to run as root! (e.g. 'sudo ./do-overlay.sh')
#
# EXAMPLES:
#
#   do-overlay.sh
#
# DEPENDENCIES:
#
#   None
#
# TODO:
#
#   - Nothing, this code is perfect
#
# MODIFICATIONS:
#
#   Josh Glover <jmglov@jmglov.net> (2003/12/03): Initial revision
# =========================================================================

grep ^PORTDIR_OVERLAY /etc/make.conf >/dev/null 2>&1
if test $? -ne 0; then
  test -d /usr/local/portage || mkdir /usr/local/portage
  chown portage:portage /usr/local/portage
  echo 'PORTDIR_OVERLAY=/usr/local/portage' >>/etc/make.conf
fi
