# This file adds functions to build elf2flt
# Copyright 2009 John Williams
# Copyright 2007 Yann E. MORIN
# Licensed under the GPL v2. See COPYING in the root of this package

# Download elf2flt
do_elf2flt_get() {
    CT_GetCVS "elf2flt-cvs-${CT_ELF2FLT_VERSION}"           \
              ":pserver:anonymous@cvs.uclinux.org:/var/cvs" \
              "elf2flt"                                     \
              "" \
              "elf2flt-cvs-${CT_ELF2FLT_VERSION}"
}

# Extract elf2flt
do_elf2flt_extract() {
    CT_Extract "elf2flt-cvs-${CT_ELF2FLT_VERSION}"
    CT_Patch "elf2flt-cvs-${CT_ELF2FLT_VERSION}"
}

# Build elf2flt
do_elf2flt() {
    [ -z ${CT_KERNEL_UCLINUX_BINFMT_FLAT} ] && return 0
    mkdir -p "${CT_BUILD_DIR}/build-elf2flt"
    cd "${CT_BUILD_DIR}/build-elf2flt"

    CT_DoStep INFO "Installing elf2flt"

    elf2flt_opts=
    binutils_bld=${CT_BUILD_DIR}/build-binutils
    binutils_src=${CT_SRC_DIR}/binutils-${CT_BINUTILS_VERSION}

    CT_DoLog EXTRA "Configuring elf2flt"
    CFLAGS="${CT_CFLAGS_FOR_HOST}"                              \
    CT_DoExecLog ALL                                            \
    "${CT_SRC_DIR}/elf2flt-cvs-${CT_ELF2FLT_VERSION}/configure" \
        --build=${CT_BUILD}                                     \
        --host=${CT_HOST}                                       \
        --target=${CT_TARGET}                                   \
        --prefix=${CT_PREFIX_DIR}                               \
        --with-bfd-include-dir=${binutils_bld}/bfd              \
        --with-binutils-include-dir=${binutils_src}/include     \
        --with-libbfd=${binutils_bld}/bfd/libbfd.a              \
        --with-libiberty=${binutils_bld}/libiberty/libiberty.a  \
        ${elf2flt_opts}                                         \
        ${CT_ELF2FLT_EXTRA_CONFIG}			

    CT_DoLog EXTRA "Building elf2flt"
    CT_DoExecLog ALL make ${PARALLELMFLAGS}

    CT_DoLog EXTRA "Installing elf2flt"
    CT_DoExecLog ALL make install

    # Make those new tools available to the core C compilers to come.
    # Note: some components want the ${TARGET}-{ar,as,ld,strip} commands as
    # well. Create that.
    mkdir -p "${CT_CC_CORE_STATIC_PREFIX_DIR}/${CT_TARGET}/bin"
    mkdir -p "${CT_CC_CORE_STATIC_PREFIX_DIR}/bin"
    mkdir -p "${CT_CC_CORE_SHARED_PREFIX_DIR}/${CT_TARGET}/bin"
    mkdir -p "${CT_CC_CORE_SHARED_PREFIX_DIR}/bin"
    for t in elf2flt flthdr; do
        ln -sv "${CT_PREFIX_DIR}/bin/${CT_TARGET}-${t}" "${CT_CC_CORE_STATIC_PREFIX_DIR}/${CT_TARGET}/bin/${t}"
        ln -sv "${CT_PREFIX_DIR}/bin/${CT_TARGET}-${t}" "${CT_CC_CORE_STATIC_PREFIX_DIR}/bin/${CT_TARGET}-${t}"
        ln -sv "${CT_PREFIX_DIR}/bin/${CT_TARGET}-${t}" "${CT_CC_CORE_SHARED_PREFIX_DIR}/${CT_TARGET}/bin/${t}"
        ln -sv "${CT_PREFIX_DIR}/bin/${CT_TARGET}-${t}" "${CT_CC_CORE_SHARED_PREFIX_DIR}/bin/${CT_TARGET}-${t}"
    done 2>&1 |CT_DoLog ALL

    CT_EndStep
}
