/*
 * Copyright (c) 2010-2011 Aalto University and RWTH Aachen University.
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef HIPL_HIPD_CLOSE_H
#define HIPL_HIPD_CLOSE_H

#include "lib/core/protodefs.h"
#include "lib/core/state.h"

int xmit_close(struct hip_hadb_state *entry, void *opaque);
int hip_send_close(struct hip_common *msg, int delete_ha_info);
int hip_close_check_packet(const uint8_t packet_type,
                           const enum hip_state ha_state,
                           struct hip_packet_context *ctx);
int hip_close_create_response(const uint8_t packet_type,
                              const enum hip_state ha_state,
                              struct hip_packet_context *ctx);
int hip_close_send_response(const uint8_t packet_type,
                            const enum hip_state ha_state,
                            struct hip_packet_context *ctx);
int hip_close_ack_check_packet(const uint8_t packet_type,
                               const enum hip_state ha_state,
                               struct hip_packet_context *ctx);
int hip_close_ack_handle_packet(const uint8_t packet_type,
                                const enum hip_state ha_state,
                                struct hip_packet_context *ctx);
int hip_purge_closing_ha(struct hip_hadb_state *ha, void *opaque);

#endif /* HIPL_HIPD_CLOSE_H */
