/*
 * Copyright (c) 2010 Aalto University and RWTH Aachen University.
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef HIPL_LIB_CORE_CONF_H
#define HIPL_LIB_CORE_CONF_H

#include <stdlib.h>

#include "config.h"
#include "protodefs.h"

/*
 * DO NOT TOUCH THESE, unless you know what you are doing.
 * These values are used for TYPE_xxx macros.
 */

/**
 * Execute application with hip-libraries preloaded.
 * Overides example getaddrinfo().
 * @see handle_exec_application()
 */
#define EXEC_LOADLIB_HIP        12

/**
 * Execute application,no preloading of libraries.
 * @see handle_exec_application()
 */
#define EXEC_LOADLIB_NONE       13
/* @} */

/* hipconf tool actions also used outside of conf.c */
#define ACTION_ADD 1
#define ACTION_NEW 3

/* keywords used to identify hipd / hipfw as target of hipconf command */
#define HIPCONF_HIPD_KEYWORD  "daemon"
#define HIPCONF_HIPFW_KEYWORD "firewall"

int hip_handle_exec_app(int fork, int type, int argc,
                        const char *const argv[]);
int hip_do_hipconf(int argc, const char *argv[], int send_only);

/* Externally used handler functions */
/* TODO: Is there a clean way to get rid of this external use? */
int hip_conf_handle_load(struct hip_common *msg,
                         int type,
                         const char *opt[],
                         int optc,
                         int send_only);

#endif /* HIPL_LIB_CORE_CONF_H */
