/*
 * Copyright (c) 2011-2012 Aalto University and RWTH Aachen University.
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */

#define _BSD_SOURCE

#include <check.h>
#include <stdlib.h>
#include <string.h>

#include "hipfw/hipfw_defines.h"
#include "lib/core/common.h"
#include "modules/midauth/hipd/midauth.h"
#include "modules/midauth/lib/midauth_builder.h"
#include "test/mocks.h"
#include "test_suites.h"

#include "hipfw/hipfw.c"


static const unsigned char tmp_ipq_packet[] = "\xA0\x85\x07\x12\x00\x88\xFF\xFF\x00\x00"
                                              "\x00\x00\x00\x00\x00\x00\xD3\x98\x81\x4E\x00\x00\x00\x00\x27\x21\x0D"
                                              "\x00\x00\x00\x00\x00\x02\x00\x00\x00\x65\x74\x68\x31\x00\x00\x00\x00"
                                              "\x00\x00\x00\x00\x00\x00\x00\x00\x65\x74\x68\x32\x00\x00\x00\x00\x00"
                                              "\x00\x00\x00\x00\x00\x00\x00\x08\x00\x01\x00\x06\x08\x00\x27\x45\x4D"
                                              "\x26\x00\x00\x00\x00\x00\x00\x00\x00\x00\xA0\x02\x00\x00\x00\x00\x00"
                                              "\x00\x45\x00\x02\xA0\x00\x00\x40\x00\x3F\x11\xB3\xEF\xC0\xA8\x01\x0A"
                                              "\xC0\xA8\x03\x03\x29\x04\x29\x04\x02\x8C\x00\x00\x00\x00\x00\x00\x3B"
                                              "\x4F\x03\x11\x00\x00\x00\x00\x20\x01\x00\x1B\xD8\xB0\x77\xF0\xC6\x17"
                                              "\x71\x70\xDE\xD7\xF3\x20\x20\x01\x00\x17\x5D\xF8\xC4\x26\x98\xE5\x5F"
                                              "\xA2\x28\x6D\x28\x47\x00\x41\x00\x0C\x00\x00\x00\x48\x00\x00\x00\x00"
                                              "\x2D\x4A\x07\x08\x01\x41\x00\x14\x00\x00\x48\x49\x90\x7D\xD8\x95\x84"
                                              "\xB3\x8D\xDC\x18\x25\xF9\x65\xE3\x31\x3E\xDD\x01\x42\x00\x1C\x01\x02"
                                              "\x82\xEC\x42\x00\x00\x00\x00\x00\x5A\x3C\x03\x14\x9A\x0E\x9D\xCA\xF0"
                                              "\x19\xAD\x2B\xBA\x43\x33\x66\xF8\xB2\x02\x01\x00\xC3\x03\x00\xC0\x7C"
                                              "\xDA\x02\x1F\xB7\xFE\x85\xBB\xD1\x93\xFD\xB2\xFB\xC0\xB1\xAD\x09\x61"
                                              "\x1F\x8E\xDD\x8F\x1B\xFC\xC3\x97\xA1\xCE\x4C\x55\x85\xB4\x4A\x8B\x66"
                                              "\x93\x2A\xDF\x85\xC0\x3A\x84\xA2\x22\x4F\xB3\xF9\x6F\xC5\x54\x23\x9D"
                                              "\xC2\x03\xEB\xB9\x55\xA4\xF0\x19\xC0\x2B\x4C\xD1\xBF\xC9\x04\xF5\x32"
                                              "\xAB\x39\xEF\x7B\xF9\xA7\xAB\x5A\xC5\x27\x5E\x21\x83\x48\xB0\x8E\x19"
                                              "\xB4\x51\x2B\xBA\x79\x00\x62\x70\x48\xF3\x44\xAE\x49\xD4\xC9\x20\x74"
                                              "\x38\x0D\x11\xCA\xB3\x6F\x03\x47\x9A\x39\xA5\xFB\xC0\x70\xD6\xB5\xB6"
                                              "\x35\x08\xB4\xB0\x33\x19\xF9\x07\x3C\x82\x7D\x3C\x16\x0C\x74\x9A\x1F"
                                              "\x9B\xB2\xE6\xB3\xC7\xB3\x08\xE2\x10\x66\x23\x95\xF6\x00\xC7\x57\x8B"
                                              "\x19\x83\x9E\x6F\xB6\x9D\x6A\x44\x25\xF1\xFD\x45\xFB\xD4\xD9\xE8\xA7"
                                              "\xD5\xF9\xA7\xA5\xFB\xA3\x23\xD2\xDE\x67\x15\x9C\x6C\xFB\x5B\x08\xAC"
                                              "\x7F\xC9\xF9\xD7\x00\x02\x41\x00\x02\x00\x01\x00\x00\x02\xC1\x00\x92"
                                              "\x00\x88\x10\x06\x02\x02\xFF\x05\x03\x01\x00\x01\xD6\xBD\x7C\x86\xC3"
                                              "\x4A\xA3\x93\x7F\xD9\x82\xBD\x22\xF1\xC7\x4F\x72\x76\x4F\x2F\x68\xF7"
                                              "\x4F\x9D\xCE\xF3\xAE\xD4\x3B\x13\x5D\xC1\xF7\xF8\x09\x4E\xB4\xCD\x82"
                                              "\x6F\xF8\xD1\x70\x01\x4E\xC0\x64\x82\xF1\x7E\x21\x54\x62\x73\x08\xEA"
                                              "\x0A\x66\x1B\xA7\x9A\x4A\xAA\x17\x56\x77\x1D\x4D\x0D\xD2\x19\x92\xA0"
                                              "\xAC\xF7\x23\x62\xE2\xF0\xFB\x1E\x73\x19\x16\x61\x1B\x85\x02\x42\x4B"
                                              "\x89\x46\x09\x71\x42\x6F\x40\x8E\x62\x31\xA6\x4F\x17\x45\xF2\x7B\xFA"
                                              "\xF2\xB6\xC8\x87\x37\x3A\xDF\xBB\x10\xE8\xDA\x97\x31\x6C\x38\xDF\xD0"
                                              "\x97\x45\x84\x39\x61\x6C\x69\x63\x65\x00\x00\x00\x0F\xFF\x00\x04\x00"
                                              "\x00\x00\x01\xF0\x41\x00\x14\xE7\x35\x6F\x89\x30\x3E\x1E\xA7\xFB\x93"
                                              "\x8B\xBE\xD1\x34\x1F\x35\xB8\xE0\x82\x0C\xF1\x01\x00\x81\x05\xA6\xA2"
                                              "\x75\xEF\xA8\xC3\x9C\x64\x9E\x9A\xDA\xFB\x38\xB4\x05\x8C\x6A\x6E\x5B"
                                              "\x59\x9F\x11\x5B\xA6\xC0\x05\x42\xA6\x0D\x9C\x62\x17\x0E\x23\xB6\x3B"
                                              "\x15\xB8\xEC\x6F\xE3\xB6\x6E\x80\x76\x97\xBE\x5B\x5B\x1A\x90\x30\xDF"
                                              "\x1F\x32\x2C\x4E\x22\x20\x0B\xD4\x2B\x5B\x7C\xEF\x27\xEA\xB9\x80\x27"
                                              "\xEF\xBC\xB4\xAF\x97\x2A\xD5\x86\xDA\xEE\x2C\xF0\x8B\x45\x00\x10\xE1"
                                              "\x3A\x95\x35\xAC\x7C\xA8\x88\xC1\x60\xB9\x71\xD3\xE2\x29\xF7\x75\xD0"
                                              "\x7E\x27\x1B\x21\x43\xAE\xBB\x08\xE1\x6B\x9E\x1E\xB9\x55\x89\xE3\x2B"
                                              "\x29\x06\x4A\xA2\x90\x98\x38\x00\x00\x00";
static const uint8_t opaque[] = "\x01\x41\x01\x14\x05\x00\x48\x49\x0b"
                                "\x02\x42\x02\x15\x06\x08\x49\x50\x0c";

#ifdef HAVE_TCASE_ADD_EXIT_TEST
START_TEST(hipfw_splice_param_NULL_ctx)
{
    struct hip_common           *tmp_msg = NULL;
    const struct hip_tlv_common *param   = NULL;

    tmp_msg = hip_msg_alloc();
    hip_build_param_challenge_request(tmp_msg, 0, 0, opaque,
                                      MIDAUTH_DEFAULT_NONCE_LENGTH);
    param = hip_get_param(tmp_msg, HIP_PARAM_CHALLENGE_REQUEST);

    fail_unless(hipfw_splice_param(NULL, param) == false, NULL);
}
END_TEST

START_TEST(hipfw_splice_param_NULL_param)
{
    struct hip_fw_context ctx;

    mock_ipq         = true;
    mock_ipq_pkt_len = ARRAY_SIZE(tmp_ipq_packet);

    fail_unless(fw_init_context(&ctx, tmp_ipq_packet, 4) == 0, NULL);
    fail_unless(hipfw_splice_param(&ctx, NULL) == false, NULL);
}
END_TEST
#endif

Suite *firewall_rewrite(void)
{
    Suite *s          = suite_create("hipfw/rewrite");
    TCase *tc_rewrite = tcase_create("rewrite");

#ifdef HAVE_TCASE_ADD_EXIT_TEST
    tcase_add_exit_test(tc_rewrite, hipfw_splice_param_NULL_ctx, 1);
    tcase_add_exit_test(tc_rewrite, hipfw_splice_param_NULL_param, 1);
#endif
    suite_add_tcase(s, tc_rewrite);

    return s;
}
